#include <iostream>
#include <vector>

using namespace std;

int main() {
    int N, K;
    cin >> N >> K;

    vector<pair<int, int>> runners(N); // pair of (starting position, speed)

    for (int i = 0; i < N; ++i) {
        cin >> runners[i].first >> runners[i].second;
    }

    double time = 0;
    while (true) {
        // Check if any runner overtakes another
        for (int i = 0; i < N; ++i) {
            for (int j = i + 1; j < N; ++j) {
                double overtaking_time = (double)(runners[j].first - runners[i].first) / (runners[i].second - runners[j].second);
                if (overtaking_time > 0 && overtaking_time < K) {
                    cout << overtaking_time << endl;
                    return 0;
                }
            }
        }

        // If no overtaking occurred, update the positions of runners
        for (int i = 0; i < N; ++i) {
            runners[i].first += runners[i].second * K;
        }

        time += K;
    }

    return 0;
}